local assets=
{ 
    Asset("ANIM", "anim/wand_abakan.zip"),
	Asset("ANIM", "anim/swap_wand_abakan.zip"),
    Asset("ATLAS", "images/inventoryimages/wand_abakan.xml"),
	Asset("IMAGE", "images/inventoryimages/wand_abakan.tex"),
}

local dam = 59

local function onattack_abakan(inst, owner, target)
    inst.SoundEmitter:PlaySound("shots/gunshot/abakanshot")	
	owner.components.inventory:ConsumeByName("warsaw545", 1)	
end

local function OnEquip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_object", "swap_wand_abakan", "wand")
        owner.AnimState:Show("ARM_carry") 
        owner.AnimState:Hide("ARM_normal") 
end

local function OnUnequip(inst, owner) 
        owner.AnimState:Hide("ARM_carry") 
        owner.AnimState:Show("ARM_normal") 
end



local function fn(colour)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
    ---- 
    MakeInventoryPhysics(inst)
    
	
    anim:SetBank("wand")
    anim:SetBuild("wand_abakan")
    anim:PlayAnimation("idle")
		
	inst:AddComponent("weapon")
	inst.components.weapon:SetDamage(dam)
    inst.components.weapon:SetRange(12)
    inst.components.weapon:SetOnAttack(onattack_abakan)
    inst.components.weapon:SetProjectile("warsaw545")
		
	inst:AddComponent("inspectable")
		
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wand_abakan"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wand_abakan.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
	inst.HasAmmo = function(inst, owner)
		if (owner and owner.components.inventory and owner.components.inventory:Has("warsaw545", 1)) or (owner:HasTag("ai")) then
			return true
		end
		return false
	end
	
    return inst
end

return  Prefab("common/inventory/wand_abakan", fn, assets)